float4x4 matView;
float4x4 matProjection;
float4x4 matViewProjection;
float4x4 matWorld;
float4x4 matWorldView;
float4x4 matWorldViewProjection;
float4x4 matMirror;

float time; 
float const0;
float const1;

float3 CameraPosition;
float3 CameraTarget;

bool    usealpha;
texture tex0;
texture tex1;
texture tex2;

sampler sTex0 = sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex1 = sampler_state
{
	texture = (tex1);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex2 = sampler_state
{
	texture = (tex2);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

////////////////////////////////////////////////////////
struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex0 : TEXCOORD0;
	float3 norm : NORMAL;
};

struct VS_OUTPUT
{
	float4 pos : POSITION;
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
	float4 diffuse : COLOR0;
};

VS_OUTPUT TextPlaneVS(VS_INPUT i)
{
	VS_OUTPUT o;
	//o.pos = mul(i.pos, matProjection);

	o.pos = mul(i.pos, matWorldViewProjection);
	o.tex0.x = (i.tex0.x*.02f)+((time-103.4f)*.04f);
	o.tex0.y = -i.tex0.y;
	o.tex1.x = i.tex0.x*26.f;
	o.tex1.y = i.tex0.y*19.f;
	float2 speccoords = mul(i.tex0, matWorldView);
	o.diffuse = float4(i.norm.x*3.f, i.norm.y*.4f, speccoords.x, speccoords.y);
	return o;
};

VS_OUTPUT StencilVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);
	o.tex0 = i.tex0;
	o.tex1 = i.tex0;
	o.diffuse = float4(i.norm.x*3.f, i.norm.y*.4f, 1.f, 1.f);
	return o;
};

VS_OUTPUT GreetPlaneVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matProjection);
	o.tex0.x = i.tex0.x*39.f;
	o.tex0.y = i.tex0.y*29.f;
	o.tex1.x = (i.tex0.x*.02f)+((time-123.2f)*.02f);
	o.tex1.y = i.tex0.y;
	o.diffuse = float4(i.norm.x*3.f, i.norm.y*.4f, 1.f, 1.f);
	return o;
}

VS_OUTPUT PlanBVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);
	o.tex0 = i.tex0;
	o.tex1 = i.tex0;
	o.diffuse = float4(1.f, 0.f, 0.f, .1f);
	return o;
}
//////////////////////////////////////////////////////////

struct PS_INPUT
{
	float4 diffuse : COLOR0;
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
};

float4 GreetPlanePS(PS_INPUT i) : COLOR0
{
//	float4 tile = tex2D(sTex2, i.tex0);
//	float4 greets = tex2D(sTex1, i.tex1);
	float4 base = tex2D(sTex0, float2(i.diffuse.x+time, i.diffuse.y+time));
//	tile.rgb += (base.rgb*(1-tile.a));
//	tile.rgb *= (1.f-greets.a);
//	tile.a = 1.f;
	return base;
}

float4 GreetPlaneTPS(PS_INPUT i) : COLOR0
{
	float4 tile = tex2D(sTex2, i.tex0);
//	float4 greets = tex2D(sTex1, i.tex1);
//	float4 base = tex2D(sTex0, float2(i.diffuse.x+time, i.diffuse.y+time));
//	tile.rgb += (base.rgb*(1-tile.a));
//	tile.rgb *= (1.f-greets.a);
//	tile.a = 1.f;
	return tile;
}


float4 TextPlanePS(PS_INPUT i) : COLOR0
{
	float4 floorbase = tex2D(sTex0, float2(i.diffuse.x+(time*.1f), i.diffuse.y+(time*.1f)));
	//floorbase *= tex2D(sTex1, i.tex0);
	float4 specular = tex2D(sTex1, float2(i.diffuse.z, i.diffuse.w));
	floorbase.rgb += (specular.rgb);
	return floorbase;//loat4(1.f, 0.f, 0.f, 1.f);//floorbase;
};

float4 TextPlaneTilePS(PS_INPUT i) : COLOR0
{
	float4 tile = tex2D(sTex0, i.tex1);
	float4 specular = tex2D(sTex1, float2(i.diffuse.z, i.diffuse.w));
	tile.rgb += (specular.rgb);
	return tile;
};

float4 TextTextPS(PS_INPUT i) : COLOR0
{
	float4 d = tex2D(sTex1, i.tex0);
	return d;
};

float4 StencilPS(PS_INPUT i) : COLOR0
{
	return float4(0.f, 0.f, 0.f, 0.f);
}

float4 PlanBPS(PS_INPUT i) : COLOR0
{
	return tex2D(sTex0, i.tex0);
}
////////////////////////////////////////////////////////////

technique TextPlane
{
	pass p0
	{
		VertexShader = compile vs_2_0 TextPlaneVS();
		PixelShader  = compile ps_2_0 TextPlanePS(); 
	}
	
	pass p1
	{
		VertexShader = compile vs_2_0 TextPlaneVS();
		PixelShader  = compile ps_2_0 TextPlaneTilePS(); 
	}
	
	pass p2
	{
		VertexShader = compile vs_2_0 TextPlaneVS();
		PixelShader  = compile ps_2_0 TextTextPS(); 
	}
}

technique GreetFloor
{
	pass p0
	{
		VertexShader = compile vs_2_0 GreetPlaneVS();
		PixelShader  = compile ps_2_0 GreetPlanePS();
	}
	
	pass p1
	{
		VertexShader = compile vs_2_0 GreetPlaneVS();
		PixelShader  = compile ps_2_0 GreetPlaneTPS();
	}
}

technique Stencil
{
	pass p0
	{
		VertexShader = compile vs_2_0 StencilVS();
		PixelShader  = compile ps_2_0 StencilPS();
	}
}

technique PlanB
{
	pass p0
	{
		VertexShader = compile vs_2_0 PlanBVS();
		PixelShader  = compile ps_2_0 PlanBPS();
	}
}